(function() {
  //Farmerswife  4/06/2013
  define(['jquery', 'underscore', 'Handlebars', 'Backbone', 'moment', 'models/event/EventModel', 'collections/event/EventCollection', 'views/event/EventView', 'models/bookingstructures/BookingstructuresModel', 'PrecompiledTemplates'], function($, _, Handlebars, Backbone, Moment, EventModel, EventCollection, EventView, BookingstructuresModel) {
    var NotificationListView;
    return NotificationListView = class NotificationListView extends Backbone.View {
      initialize(usr, notCol) {
        this.usr = usr;
        this.notCol = notCol;
        this.notCol.on('collectionNotificationFilled', this.__update_notification_list, this);
        return this.notCol.get_notifications(this.usr);
      }

      events() {
        return {
          'tap #id-btn-panel': 'btnPanelClicked',
          // ACCPET BOOKING
          'tap .span-wrap-btns-booking > .btn': 'btnBookingStatusClicked',
          // CLICKABLE
          'tap .clickable': 'btnGoToBookingClicked'
        };
      }

      render() {
        var template;
        template = Handlebars.templates['NotificationListView'];
        this.$el.html(template());
        this.$el.attr('id', 'id-NotificationListView');
        this.addSidePanel();
        return this.$el;
      }

      addSidePanel() {
        var MenuView;
        if (!MenuView) {
          MenuView = require("views/menu/MenuView");
        }
        this.panel = new MenuView(this.usr, this.obj);
        this.panel.render();
        return this.$el.append(this.panel.el);
      }

      __update_notification_list() {
        var ul;
        this.$el.find('#id-spinner-all').hide();
        ul = this.$el.find('#id-ul-notification-list');
        ul.empty();
        this.notCol.each(function(nt) {
          var aUN, arrow, attrs, btns, clickable, html, li, read, ref;
          btns = '';
          attrs = '';
          arrow = '';
          clickable = '';
          html = `<div><span class='notification-desc'>${nt.get('description')}</span></div><div>`;
          if ((ref = nt.get('category')) === 'Alarm' || ref === 'Event') {
            aUN = nt.get('actionUserName') ? nt.get('actionUserName') : '';
            html += `<p class='fwi-alarm'>${aUN}`;
            html += `<span style='float:right;'>${Handlebars.helpers.beautyDate(nt.get('date'))}</span></p> </div>`;
          } else {
            html += `<p><span style='float:right;'>${Handlebars.helpers.beautyDate(nt.get('date'))}</span></p> </div>`;
          }
          read = nt.get('hasBeenRead') === 1 ? '' : 'notification-unread';
          if (nt.get('acceptStatus') === -1) {
            btns = "<span class='span-wrap-btns-booking'><a href='#' class='btn btn-yes btn-accept-booking' data-role='button'>Accept</a><a href='#' class='btn btn-no btn-decline-booking' data-role='button'>Decline</a> </span>";
          }
          if (nt.get('eventID') && nt.get('bookingLineID')) {
            arrow = "<span class='fwi-arrow-right arrow-right'/>";
            clickable = 'clickable';
            attrs = `data-eventID=\"${nt.get('eventID')}\" data-bookingLineID=\"${nt.get('bookingLineID')}\" `;
          }
          li = `<li class=\"${read} ${clickable}\" ${attrs}>${html}${btns}${arrow}</li>`;
          ul.append(li);
          if (btns.length > 1) {
            return ul.find('.btn').button();
          }
        });
        return ul.listview('refresh');
      }

      btnBookingStatusClicked(event) {
        var bookingLineID, btn, ev, eventID, li, requestObject, status, that;
        event.preventDefault();
        event.stopPropagation();
        btn = $(event.currentTarget);
        that = this;
        if (btn.hasClass('btn-yes')) {
          status = 1;
        } else {
          status = 0;
        }
        li = btn.parents('li');
        eventID = li.attr('data-eventID');
        bookingLineID = li.attr('data-bookingLineID');
        requestObject = {
          'bookingLineID': bookingLineID,
          'eventID': eventID,
          'sessionID': this.usr.get('sessionID'),
          'acceptStatus': status
        };
        $.mobile.loading('show');
        ev = new EventModel();
        return ev.set_booking_accept_status(requestObject).done(function(data, textStatus, jqXHR) {
          var jsonObj;
          jsonObj = data;
          if (jsonObj.Result.isError === "0" || jsonObj.Result.isError === 0) {
            //that.panel.__refresh_current_view()
            return li.find('.span-wrap-btns-booking').hide();
          }
        }).fail(function(data, textStatus, jqXHR) {
          return false;
        }).always(function(data, textStatus) {
          return $.mobile.loading('hide');
        });
      }

      btnGoToBookingClicked(event) {
        var bs, ev, evCol, eventObj, li, nt, view;
        event.preventDefault();
        event.stopPropagation();
        bs = new BookingstructuresModel();
        bs.get_booking_structures(this.usr);
        li = $(event.currentTarget);
        nt = this.notCol.findWhere({
          'eventID': li.attr('data-eventID')
        });
        //day = Moment(nt.get('date').split(' ')[0])
        eventObj = {
          'bookingID': li.attr('data-eventID'),
          'bookingLineID': li.attr('data-bookingLineID'),
          'day': ""
        };
        ev = new EventModel(eventObj);
        evCol = new EventCollection();
        ev.get_details_event(this.usr.get('sessionID'), 'type', 'NOTIFICATIONDAY');
        if (!EventView) {
          EventView = require("views/event/EventView");
        }
        view = new EventView(this.usr, bs, evCol, ev, null, null);
        return $.mobile.jqmNavigator.pushView(view, {
          transition: "none"
        });
      }

      btnPanelClicked(event) {
        event.preventDefault();
        event.stopPropagation();
        return this.panel.btnPanelClicked(event);
      }

    };
  });

}).call(this);
